/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.preferences;

import com.aptana.editor.php.core.preferences.TaskTag;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org2.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org2.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org2.eclipse.php.internal.core.preferences.TaskTagsProvider;

public class TaskPatternsProvider {
    private static TaskPatternsProvider instance;
    private TaskTagsProvider provider = TaskTagsProvider.getInstance();
    private Pattern[] workspacePatterns;
    private HashMap<IProject, Pattern[]> projectsPatterns = new HashMap();
    private HashMap<IProject, ITaskTagsListener> projectToListener = new HashMap();

    private TaskPatternsProvider() {
        this.initPatternsDB();
    }

    public static TaskPatternsProvider getInstance() {
        if (instance == null) {
            instance = new TaskPatternsProvider();
        }
        return instance;
    }

    public Pattern[] getPatternsForProject(IProject project) {
        this.registerProject(project);
        Pattern[] patterns = this.projectsPatterns.get(project);
        if (patterns != null) {
            return patterns;
        }
        patterns = this.workspacePatterns;
        return patterns;
    }

    private void initPatternsDB() {
        this.workspacePatterns = this.createPatterns(this.provider.getWorkspaceTaskTags(), this.provider.isWorkspaceTagsCaseSensitive());
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects == null) {
            return;
        }
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.registerProject(project);
            ++i;
        }
    }

    public Pattern[] getPetternsForWorkspace() {
        return this.workspacePatterns;
    }

    private void registerProject(IProject project) {
        if (this.projectToListener.get(project) == null) {
            TaskTag[] tags = this.provider.getProjectTaskTags(project);
            boolean caseSensitive = this.provider.getProjectTagsCaseSensitive(project);
            if (tags != null) {
                Pattern[] patterns = this.createPatterns(tags, caseSensitive);
                this.projectsPatterns.put(project, patterns);
            }
            TaskTagsListener tagsListener = new TaskTagsListener();
            this.provider.addTaskTagsListener(tagsListener, project);
            this.projectToListener.put(project, tagsListener);
        }
    }

    private Pattern[] createPatterns(TaskTag[] workspaceTaskTags, boolean caseSensitive) {
        Pattern[] patterns = new Pattern[workspaceTaskTags.length];
        int i = 0;
        while (i < workspaceTaskTags.length) {
            TaskTag tag = workspaceTaskTags[i];
            String tagString = tag.getTag();
            patterns[i] = caseSensitive ? Pattern.compile(tagString, 16) : Pattern.compile(tagString, 18);
            ++i;
        }
        return patterns;
    }

    private void taskTagsChanged(IProject project, TaskTag[] tags, boolean caseSensitive) {
        if (project == null) {
            this.workspacePatterns = this.createPatterns(tags, caseSensitive);
            return;
        }
        if (tags == null) {
            this.projectsPatterns.remove(project);
            return;
        }
        Pattern[] patterns = this.createPatterns(tags, caseSensitive);
        this.projectsPatterns.put(project, patterns);
    }

    private class TaskTagsListener
    implements ITaskTagsListener {
        private TaskTagsListener() {
        }

        @Override
        public void taskTagsChanged(TaskTagsEvent event) {
            TaskPatternsProvider.this.taskTagsChanged(event.getProject(), event.getTaskTags(), event.isCaseSensitive());
        }

        @Override
        public void taskPrioritiesChanged(TaskTagsEvent event) {
        }

        @Override
        public void taskCaseChanged(TaskTagsEvent event) {
            TaskPatternsProvider.this.taskTagsChanged(event.getProject(), event.getTaskTags(), event.isCaseSensitive());
        }
    }
}

